﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Xml;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using PI.FM.N000.Base.WinForms.Ribbon;
using Gemini.Core.WinForms.Controls.Type;
using Gemini.Core.WinForms.Controls.Interface;
using Gemini.Core.WinForms.Base;


namespace PI.ZB.N1200.ELearning.WinForms.Competence
{
    public partial class UCCompetenceDetails : PI.FM.N000.Base.WinForms.Controls.UCBODetails<BL.BO.Competence, BL.BO.Competence.Search>
    {
        private const int _IndexTabCompetenceDetails = 0;
        private const int _IndexTabCompetenceCompetenceParts = 1;
        private const int _IndexTabCompetenceDescription = 2;
        protected     int _IndexTabSystemInformation    = 3;

        private PI.ZB.N1200.ELearning.BL.ZSBELearning _blZSBELearning = null;

        private UCTabCompetenceDetails _tabCompetenceDetails = null;
        private UCTabCompetenceCompetenceParts _tabCompetenceCompetenceParts = null;
        private UCTabCompetenceDescription _tabCompetenceDescription = null;

        internal virtual PI.ZB.N1200.ELearning.BL.ZSBELearning BLZSBELearning
        {
            get
            {
                if (_blZSBELearning == null)
                {
                    _blZSBELearning = new PI.ZB.N1200.ELearning.BL.ZSBELearning(Environment);
                }
                return _blZSBELearning;
            }
        }

        public UCTabCompetenceDetails TabCompetenceDetails
        {
            get
            {
                if (_tabCompetenceDetails == null)
                {
                    _tabCompetenceDetails = new UCTabCompetenceDetails();
                }
                return _tabCompetenceDetails;
            }
        }

        public UCTabCompetenceCompetenceParts TabCompetenceCompetenceParts
        {
            get
            {
                if (_tabCompetenceCompetenceParts == null)
                {
                    _tabCompetenceCompetenceParts = new UCTabCompetenceCompetenceParts();
                }
                return _tabCompetenceCompetenceParts;
            }
        }

        public UCTabCompetenceDescription TabCompetenceDescription
        {
            get
            {
                if (_tabCompetenceDescription == null)
                {
                    _tabCompetenceDescription = new UCTabCompetenceDescription();
                }
                return _tabCompetenceDescription;
            }
        }

        protected int IndexTabSystemInformation
        {
            set
            {
                _IndexTabSystemInformation = value;
            }
            get
            {
                return _IndexTabSystemInformation;
            }
        }

        public UCCompetenceDetails()
        {
            InitializeComponent();

            AddStandardControlTabs();

            MinimumHorizontalSize = 420;
            MinimumVerticalSize = 420;
        }

        protected void AddStandardControlTabs()
        {
            this.AddControlAtTab(_IndexTabCompetenceDetails, TabCompetenceDetails, "Ustawienia");
            this.AddControlAtTab(_IndexTabCompetenceCompetenceParts, TabCompetenceCompetenceParts, "Powiązane kompetencje składowe");
            this.AddControlAtTab(_IndexTabCompetenceDescription, TabCompetenceDescription, "Opis");
            this.AddControlAtTab(_IndexTabSystemInformation, TabSystemInformation, "Informacje systemowe");
        }

        public override void Initialize(Gemini.Core.WinForms.Interface.IPlugIn ParentPlugIn, Gemini.Core.WinForms.Interface.IEnvironment ParentEnvironment)
        {
            base.Initialize(ParentPlugIn, ParentEnvironment);

            TabCompetenceDetails.Initialize(this, Environment, Plugin);
            TabCompetenceCompetenceParts.Initialize(this, Environment, Plugin);
            TabCompetenceDescription.Initialize(this, Environment, Plugin);
            TabSystemInformation.Initialize(this, Environment, Plugin);
        }

        protected override Gemini.Core.BL.Base.MethodResult DoSave()
        {
            Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

            TabCompetenceDetails.Save();
            TabCompetenceDescription.Save();
            _methodResult = BLZSBELearning.Competence.Save(DataManager.Current);

            return _methodResult;
        }

        protected override void DoExtendToolbarActions()
        {
            if (TabControl.SelectedTabPageIndex == _IndexTabCompetenceDescription)
            {
                PI.FM.N000.Base.WinForms.Ribbon.HtmlRibbonToolbar.Extend();
            }
        }

        protected override bool DoRestore(long? ID)
        {
            bool _result = false;
            BL.BO.Competence _Competence = BLZSBELearning.Competence.Restore(ID);
            if (_Competence != null)
            {
                DataManager.LoadData(null, null, _Competence);
                TabCompetenceDetails.Restore();
                TabCompetenceCompetenceParts.Restore();
                TabCompetenceDescription.Restore();
                _result = true;
            }

            return _result;
        }

        protected override Gemini.Core.BL.Base.MethodResult DoRemove()
        {
             return BLZSBELearning.Competence.Remove(DataManager.Current);
        }

        protected override bool DoConfirmDelete()
        {
            bool _return = false;

            if (DataManager.Current != null)
            {
                FRemoveCompetence _dialog = Gemini.Core.WinForms.Base.Form.Create<FRemoveCompetence>(this.Plugin, Environment);
                _dialog.Initialize(BLZSBELearning, DataManager.Current);

                if (DialogResult.OK == _dialog.ShowDialog())
                {
                    _return = true;
                }
                else
                {
                    _return = false;
                }
            }
            return _return;
        }

        protected override void DoCreateToolbarActions()
        {
            if (TabControl.SelectedTabPageIndex == _IndexTabCompetenceCompetenceParts)
            {
                this.ControlActionDefineGroups(TabCompetenceCompetenceParts.DataManagerCompetenceParts);
            }
        }
    }
}
